import { makeStyles } from '@material-ui/core/styles';
import { BUTTON_COLOR, BUTTON_HOVER_COLOR } from 'constants/colors';

const useStyles = makeStyles(() => ({
    styledButton: {
        width: 'auto',
        height: 'auto',
        padding: '12px 20px',
        margin: 0,
        borderRadius: 4,
        border: `1px solid ${BUTTON_COLOR}`,
        backgroundColor: BUTTON_COLOR,
        boxSizing: 'content-box',
        fontSize: 16,
        fontWeight: 'bold',
        fontFamily: 'Roboto-Condensed-Regular',
        fontStyle: 'normal',
        lineHeight: 1.5,
        letterSpacing: 1,
        textAlign: 'center',
        color: '#ffffff',
        boxShadow: 'none',
        '&:hover': {
            backgroundColor: BUTTON_HOVER_COLOR
        }
    },
    bigSize: {
        minWidth: 141,
        height: 22,
        padding: '12px 20px'
    },
    smallSize: {
        minWidth: 79,
        size: 34,
        padding: '6px 20px',
        fontSize: 14,
        lineHeight: 1.71,
        letterSpacing: '0.6px'
    },
    outlined: {
        textAlign: 'center',
        background: 'none',
        borderColor: BUTTON_COLOR,
        color: BUTTON_COLOR,
        '&:hover': {
            backgroundColor: '#d9e7ef'
        }
    }
}));

export default useStyles;
